/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef _CALIBRATIONAPPLYFROMRAWCOMMAND_H_
#define _CALIBRATIONAPPLYFROMRAWCOMMAND_H_

#include "ICommand.h"
#include "CalibrationTypes.h"
#include "InputDeviceConfiguration.h"

class CalibrationApplyFromRawCoordinateCommand: public ICommand
{
public:
    /*!
     * \action    This command sets the calibration parameters for a given
     *            input device
     * \frequency
     * \param[in] sender               Process id of the application that sent this
     *                                 command
     * \param[in] deviceName           Name of the input device
     * \param[in] subdivisionName      Name of the logical subdivision
     * \param[in] measuredRaw1         The first measured raw coordinate
     * \param[in] measuredRaw2         The second measured raw coordinate
     * \param[in] measuredRaw3         The third measured raw coordinate
     * \param[in] requiredLogical1     The first required logical coordinate
     * \param[in] requiredLogical2     The second required logical coordinate
     * \param[in] requiredLogical3     The third required logical coordinate
     * \ingroup   Commands
     */
    CalibrationApplyFromRawCoordinateCommand(pid_t sender,
                                             const std::string& deviceName,
                                             const std::string& subdivisionName,
                                             LayerManagerCalibration::coordinate* measuredRaw1,
                                             LayerManagerCalibration::coordinate* measuredRaw2,
                                             LayerManagerCalibration::coordinate* measuredRaw3,
                                             LayerManagerCalibration::coordinate* requiredLogical1,
                                             LayerManagerCalibration::coordinate* requiredLogical2,
                                             LayerManagerCalibration::coordinate* requiredLogical3)
    : ICommand(ExecuteSynchronous, sender)
    , m_deviceName(deviceName)
    , m_subdivisionName(subdivisionName)
    , m_measuredRaw1(measuredRaw1)
    , m_measuredRaw2(measuredRaw2)
    , m_measuredRaw3(measuredRaw3)
    , m_requiredLogical1(requiredLogical1)
    , m_requiredLogical2(requiredLogical2)
    , m_requiredLogical3(requiredLogical3)
    {}

    /**
     * \brief default destructor
     */
    virtual ~CalibrationApplyFromRawCoordinateCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManager
     *                     Commands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionFailed: execution failed
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    const std::string& m_deviceName;
    const std::string& m_subdivisionName;
    LayerManagerCalibration::coordinate* m_measuredRaw1;
    LayerManagerCalibration::coordinate* m_measuredRaw2;
    LayerManagerCalibration::coordinate* m_measuredRaw3;
    LayerManagerCalibration::coordinate* m_requiredLogical1;
    LayerManagerCalibration::coordinate* m_requiredLogical2;
    LayerManagerCalibration::coordinate* m_requiredLogical3;
};

#endif // _CALIBRATIONAPPLYFROMRAWCOMMAND_H_
